% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised.R
\name{mbpls}
\alias{mbpls}
\title{Multiblock Partial Least Squares - MB-PLS}
\usage{
mbpls(
  formula,
  data,
  subset,
  na.action,
  X = NULL,
  Y = NULL,
  ncomp = 1,
  scale = FALSE,
  ...
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictor block names separated by + signs.}

\item{data}{The data set to analyse.}

\item{subset}{Expression for subsetting the data before modelling.}

\item{na.action}{How to handle NAs (no action implemented).}

\item{X}{\code{list} of input blocks. If X is supplied, the formula interface is skipped.}

\item{Y}{\code{matrix} of responses.}

\item{ncomp}{\code{integer} number of PLS components.}

\item{scale}{\code{logical} for autoscaling inputs (default = FALSE).}

\item{...}{additional arguments to pls::plsr.}
}
\value{
\code{multiblock, mvr} object with super-scores, super-loadings, block-scores and block-loading, and the underlying
\code{mvr} (PLS) object for the super model, with all its result and plot possibilities. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
A function computing MB-PLS scores, loadings, etc. on the super-level and
block-level.
}
\details{
MB-PLS is the prototypical component based supervised multiblock method.
It was originally formulated as a two-level method with a block-level and a super-level,
but it was later discovered that it could be expressed as an ordinary PLS on concatenated
weighted X blocks followed by a simple loop for calculating block-level loading weights,
loadings and scores. This implementation uses the \code{\link[pls]{plsr}} function on the
scaled input blocks (1/sqrt(ncol)) enabling all summaries and plots from the \code{pls}
package.
}
\examples{
data(potato)
# Formula interface
mb <- mbpls(Sensory ~ Chemical+Compression, data=potato, ncomp = 5)
# ... or X and Y
mb.XY <- mbpls(X=potato[c('Chemical','Compression')], Y=potato[['Sensory']], ncomp = 5)
identical(mb$scores, mb.XY$scores)
print(mb)
scoreplot(mb, labels="names") # Exploiting mvr object structure from pls package
}
\references{
\itemize{
\item Wangen, L.E. and Kowalski, B.R. (1988). A multiblock partial least squares algorithm for investigating complex chemical systems. Journal of Chemometrics, 3, 3–20.
\item Westerhuis, J.A., Kourti, T., and MacGregor,J.F. (1998). Analysis of multiblock and hierarchical PCA and PLS models. Journal of Chemometrics, 12, 301–321.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
