% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{pcagca}
\alias{pcagca}
\title{PCA-GCA}
\usage{
pcagca(
  X,
  commons = 2,
  auto = TRUE,
  auto.par = list(explVarLim = 40, rLim = 0.8),
  manual.par = list(ncomp = 0, ncommon = 0),
  tol = 10^-12
)
}
\arguments{
\item{X}{\code{list} of input blocks}

\item{commons}{\code{numeric} giving the highest number of blocks to combine when calculating local or common scores.}

\item{auto}{\code{logical} indicating if automatic choice of complexities should be used.}

\item{auto.par}{\code{named list} setting limits for automatic choice of complexities.}

\item{manual.par}{\code{named list} for manual choice of blocks. The list consists of \code{ncomp} which indicates the number of components to extract from each block and \code{ncommon} which is the corresponding for choosing the block combinations (local/common). For the latter, use unique_combos(n_blocks, commons) to see order of local/common blocks. Component numbers will be reduced if simpler models give better predictions. See example.}

\item{tol}{\code{numeric} tolerance for component inclusion (singular values).}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
PCA-GCA is a methods which aims at estimating subspaces of common, local and
distinct variation from two or more blocks.
}
\details{
The name PCA-GCA comes from the process of first applying
PCA to each block, then using GCA to estimate local and common components, and finally
orthogonalising the block-wise scores on the local/common ones and re-estimating these to
obtain distinct components. The procedure is highly similar to the supervised method
PO-PLS, where the PCA steps are exchanged with PLS.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.pcagca <- pcagca(potList)
plot(scores(pot.pcagca, block=2), comps=1, labels="names")

}
\references{
Smilde, A., Måge, I., Naes, T., Hankemeier, T.,Lips, M., Kiers, H., Acar, E., and Bro, R.(2017). Common and distinct components in data fusion. Journal of Chemometrics, 31(7), e2900.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
