% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antiImage.R
\name{antiImage}
\alias{antiImage}
\title{Anti-image matrix}
\usage{
antiImage(X)
}
\arguments{
\item{X}{A data frame with the values of numerical variables.}
}
\value{
A list with two elements:
\itemize{
\item \code{AIR} - Anti-image matrix.
\item \code{KMO} - Overall KMO.
}
}
\description{
The function computes anti-image matrix (i.e., with partial correlations on the off-diagonal and with KMO-MSAs on the diagonal) and the overall KMO.
}
\examples{
antiImage(X = mtcars[, c(1, 3, 4, 5)])
}
\references{
Kaiser, H. F., & Rice, J. (1974). Little Jiffy, Mark Iv. Educational & Psychological Measurement, 34(1), 111.
}
\author{
Marjan Cugmas
}
