% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sketches_test}
\alias{sketches_test}
\title{Images of sketches for testing}
\format{
A data frame with 1200 rows and 786 columns
}
\description{
This data is a subset of images from https://quickdraw.withgoogle.com
The subset was created using the quickdraw R package at
https://huizezhang-sherry.github.io/quickdraw/.
It has 6 different groups: banana, boomerang, cactus, flip flops,
kangaroo. Each image is 28x28 pixels.
}
\details{
\describe{
\item{V1-V784}{grey scale 0-255}
\item{word}{all NA, you need to predict this}
\item{id}{unique id for each sketch}
}
}
\examples{

require(ggplot2)
data("sketches_test")
x <- sketches_test[sample(1:nrow(sketches_test), 1), ]
xm <- data.frame(gry=t(as.matrix(x[,1:784])),
        x=rep(1:28, 28),
        y=rep(28:1, rep(28, 28)))
ggplot(xm, aes(x=x, y=y, fill=gry)) +
  geom_tile() +
  scale_fill_gradientn(colors = gray.colors(256, start = 0, end = 1, rev = TRUE )) +
  theme_void() + theme(legend.position="none")
}
\seealso{
sketches_train
}
\keyword{datasets}
