% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HVT.R
\name{HVT}
\alias{HVT}
\title{Constructing Hierarchical Voronoi Tessellations}
\usage{
HVT(dataset, nclust, depth, quant.err, projection.scale, normalize)
}
\arguments{
\item{dataset}{Data frame. A data frame with different columns is given as
input.}

\item{nclust}{Numeric. An integer indicating the number of clusters per
hierarchy (level)}

\item{depth}{Numeric. An integer indicating the number of levels. (1 = No
hierarchy, 2 = 2 levels, etc ...)}

\item{quant.err}{Numeric. A number indicating the quantization error
treshold.}

\item{projection.scale}{Numeric. A number indicating the scale factor for
the tesselations so as to visualize the sub-tesselations well enough.}

\item{normalize}{Logical. A logical value indicating if the columns in your
dataset should be normalized. Default value is TRUE.}
}
\value{
A list that contains the hierarchical tesselation information. This
list has to be given as input argument to plot the tessellations.
\item{[[1]] }{List. Information about the tesselation co-ordinates - level
wise} \item{[[2]] }{List. Information about the polygon co-ordinates - level
wise} \item{[[3]] }{List. Information about the hierarchical vector
quantized data - level wise}
}
\description{
Main function to construct hierarchical voronoi tessellations.
}
\details{
This is the main function to construct hierarchical voronoi tessellations.
The \code{hvq} function is called from this function. The output of the
\code{hvq} function is hierarchical clustered data which will be the input
for constructing tessellations. The data is then represented in 2d
coordinates and the tessellations are plotted using these coordinates as
centroids. For subsequent levels, transformation is performed on the 2d
coordinates to get all the points within its parent tile. Tessellations are
plotted using these transformed points as centroids. The lines in the
tessellations are chopped in places so that they do not protrude outside the
parent polygon. This is done for all the subsequent levels.
}
\examples{

data("iris",package="datasets")
iris <- iris[,1:2]
hvt.results <- list()
hvt.results <- HVT(iris, nclust = 6, depth = 1, quant.err = 0.2, 
projection.scale = 10, normalize = TRUE)

plotHVT(hvt.results, line.width = c(3), color.vec = c("blue"))

hvt.results <- list()
hvt.results <- HVT(iris, nclust = 6, depth = 3, quant.err = 0.2, 
projection.scale = 10, normalize = TRUE)


plotHVT(hvt.results, line.width = c(4,3), color.vec = c("red", "green"))


}
\seealso{
\code{\link{plotHVT}} \cr \code{\link{hvtHmap}}
}
\author{
Meet K. Dave <dave.kirankumar@mu-sigma.com>
}
\keyword{hplot}
