% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microstrategy.R
\docType{methods}
\name{create_dataset}
\alias{create_dataset}
\alias{create_dataset,connection-method}
\title{Create an in-memory MicroStrategy dataset}
\usage{
create_dataset(connection, data_frame, dataset_name, table_name,
  to_metric = NULL, to_attribute = NULL)

\S4method{create_dataset}{connection}(connection, data_frame, dataset_name,
  table_name, to_metric = NULL, to_attribute = NULL)
}
\arguments{
\item{connection}{MicroStrategy REST API connection object}

\item{data_frame}{R Data.Frame from which an in-memory dataset will be created}

\item{dataset_name}{Name of the in-memory dataset}

\item{table_name}{Name of the table to create within the dataset}

\item{to_metric}{(optional) A vector of column names from the Data.Frame to format as metrics
in the dataset. By default, numeric types are formatted as metrics while character and date types are formatted as attributes.
For example, a column of integer-like strings ("1", "2", "3") would
appear as an attribute in the newly created dataset. If the intent is to format this data as a metric, provide the
corresponding column name as \code{to_metric=c('myStringIntegers')}}

\item{to_attribute}{(optional) Logical opposite of \code{to_metric}. Helpful for formatting an integer-based row identifier as
a primary key in the dataset}
}
\value{
Unique identifiers of the dataset and table within the newly created dataset. Required for \code{update_dataset()}
}
\description{
Creates an in-memory dataset from an R Data.Frame.
}
\examples{
\donttest{
df <- iris

# Create a primary key
df$ID <- as.character(row.names(df))

# Remove periods and other special characters due to their
# special role in MicroStrategy. But, "_" is ok.
names(df) <- c("Sepal_Length", "Sepal_Width", "Petal_Length", "Petal_Width", "Species", "ID")

# Create the dataset
mydf <- create_dataset(connection = conn,
                       data_frame = df,
                       dataset_name = "IRIS",
                       table_name = "IRIS")

# You can specify special treatment for columns within the data frame.
# This will convert the character-formatted row ID's to a MicroStrategy metric
mydf <- create_dataset(connection = conn,
                       data_frame = df,
                       dataset_name = "IRIS",
                       table_name = "IRIS",
                       to_metric = c("ID"))

# This will convert 'Sepal_Length' and 'Sepal_Width' to attributes
mydf <- create_dataset(connection = conn,
                       data_frame = df,
                       dataset_name = "IRIS",
                       table_name = "IRIS",
                       to_attribute = c("Sepal_Length", "Sepal_Width"))
}
}
