% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstDIF.R
\name{mstDIF}
\alias{mstDIF}
\alias{mstDIF.default}
\alias{mstDIF.AllModelClass}
\alias{mstDIF.dRm}
\title{A general function to detect differential item functioning (DIF) in multistage tests (MSTs)}
\usage{
\method{mstDIF}{default}(resp, DIF_covariate, method, theta = NULL, see = NULL, ...)

\method{mstDIF}{AllModelClass}(
  object,
  DIF_covariate,
  method,
  theta = NULL,
  see = NULL,
  theta_method = "WLE",
  ...
)

\method{mstDIF}{dRm}(object, DIF_covariate, method, theta = NULL, see = NULL, ...)
}
\arguments{
\item{resp, object}{A data frame or matrix containing the response matrix. Rows correspond to respondents, columns to items. Or an object of class SingleGroup-class or MultiGroup-class object as returned by mirt, or a dRm object as returned by the RM function in eRm.}

\item{DIF_covariate}{A vector of ability estimates for each respondent.}

\item{method}{A character value indicating the DIF test that should be used. Possible values are "logreg"
(Logistic regression), "mstsib" (mstSIB), "bootstrap" (score-based Bootstrap test), "permutation" (score-based)
permutation test) and "analytical" (analytical score-based test).}

\item{theta}{Estimates of the ability parameters.}

\item{see}{Estimates of the standard error of estimation.}

\item{...}{Additional, test-specific arguments.}

\item{theta_method}{Method for estimating the ability parameters if they
should be estimated based on the responses. The calculation is carried
out by the mirt package. Can be: "WLE" (default),
"MAP", "EAP", "ML", "EAPsum", "plausible", "classify".}
}
\value{
An object of class \code{mstDIF}, which is a list with the following elements:
\describe{
  \item{\code{resp}}{The response matrix as a data frame.}
  \item{\code{method}}{The used DIF detection method.}
  \item{\code{test}}{The used test or statistic.}
  \item{\code{DIF_covariate}}{The person covariate tested for DIF.}
  \item{\code{DIF_test}}{A list with the DIF-test results.}
  \item{\code{call}}{The function call.}
  \item{\code{method_results}}{The complete output of the selected DIF test.
  Differs depending on the selection.}
}
}
\description{
This function allows the application of various methods for the detection of differential item functioning
in multistage tests. Currently five methods are implemented: 1. Logistic Regression, 2. mstSIB, 3. analytical
score-base tests, 4. a score-based Bootstrap test, 5. a score-based permutation test. The required input
differs with regard to the selected DIF test.
}
\details{
Author: Rudolf Debelak and Dries Debeer
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default mstDIF method

\item \code{AllModelClass}: mstDIF method for mirt-objects

\item \code{dRm}: mstDIF method for dRm-objects
}}

\examples{

## load data
data("toydata")
resp <- toydata$resp
group_categ <- factor(toydata$group_categ)
theta_est <- toydata$theta_est
see_est <- toydata$see_est

## test DIF along a categorical covariate (a factor) using the
## logistic regression method
res1 <- mstDIF(resp, DIF_covariate = group_categ, method = "logreg",
theta = theta_est)
res1
summary(res1)

## test DIF along a categorical covariate (a factor) using the
## mstSIB method
res2 <- mstDIF(resp, DIF_covariate = factor(group_categ), method = "mstsib",
theta = theta_est, see = see_est)
res2
summary(res2)

}
\seealso{
\code{\link{mstDIF-Methods}}
}
