% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_status_tt.R
\name{pat_status_tt}
\alias{pat_status_tt}
\title{Calculate patient status at specific end of follow-up - tidytable version}
\usage{
pat_status_tt(
  wide_df,
  fu_end = NULL,
  dattype = "zfkd",
  status_var = "p_status",
  life_var = NULL,
  spc_var = NULL,
  birthdat_var = NULL,
  lifedat_var = NULL,
  lifedatmin_var = NULL,
  fcdat_var = NULL,
  spcdat_var = NULL,
  life_stat_alive = NULL,
  life_stat_dead = NULL,
  spc_stat_yes = NULL,
  spc_stat_no = NULL,
  lifedat_fu_end = NULL,
  use_lifedatmin = FALSE,
  check = TRUE,
  as_labelled_factor = FALSE
)
}
\arguments{
\item{wide_df}{dataframe or data.table in wide format}

\item{fu_end}{end of follow-up in time format YYYY-MM-DD.}

\item{dattype}{Type of cancer registry data. Can be "seer" or "zfkd". Default is "zfkd".}

\item{status_var}{Name of the newly calculated variable for patient status. Default is p_status.}

\item{life_var}{Name of variable containing life status. Will override dattype preset.}

\item{spc_var}{Name of variable containing SPC status. Will override dattype preset.}

\item{birthdat_var}{Name of variable containing Date of Birth. Will override dattype preset.}

\item{lifedat_var}{Name of variable containing Date of Death. Will override dattype preset.}

\item{lifedatmin_var}{Name of variable containing the minimum Date of Death when true DoD is missing. Will override dattype preset. Will only  be used if use_lifedatmin = TRUE.}

\item{fcdat_var}{Name of variable containing Date of Primary Cancer diagnosis. Will override dattype preset.}

\item{spcdat_var}{Name of variable containing Date of SPC diagnosis Will override dattype preset.}

\item{life_stat_alive}{Value for alive status in life_var. Will override dattype preset.}

\item{life_stat_dead}{Value for dead status in life_var. Will override dattype preset.}

\item{spc_stat_yes}{Value for SPC occurred in spc_var. Will override dattype preset.}

\item{spc_stat_no}{Value for no SPC in spc_var. Will override dattype preset.}

\item{lifedat_fu_end}{Date of last FU of alive status in registry data. Will override dattype preset (2017-03-31 for zfkd; 2018-12-31 for seer).}

\item{use_lifedatmin}{If TRUE, option to use Date of Death from lifedatmin_var when DOD is missing. Default is FALSE.}

\item{check}{Check newly calculated variable p_status. Default is TRUE.}

\item{as_labelled_factor}{If TRUE, output status_var as labelled factor variable. Default is FALSE.}
}
\value{
wide_df
}
\description{
Calculate patient status at specific end of follow-up - tidytable version
}
\examples{
#load sample data
data("us_second_cancer")

#prep step - make wide data as this is the required format
usdata_wide <- us_second_cancer \%>\%
                    msSPChelpR::reshape_wide_tidyr(case_id_var = "fake_id", 
                    time_id_var = "SEQ_NUM", timevar_max = 10)
                    
#prep step - calculate p_spc variable
usdata_wide <- usdata_wide \%>\%
                 dplyr::mutate(p_spc = dplyr::case_when(is.na(t_site_icd.2)   ~ "No SPC",
                                                       !is.na(t_site_icd.2)   ~ "SPC developed",
                                                       TRUE ~ NA_character_)) \%>\%
                 dplyr::mutate(count_spc = dplyr::case_when(is.na(t_site_icd.2)   ~ 1,
                                                              TRUE ~ 0))
                                                              
#now we can run the function
msSPChelpR::pat_status_tt(usdata_wide, 
                       fu_end = "2017-12-31", 
                       dattype = "seer", 
                       status_var = "p_status", 
                       life_var = "p_alive.1", 
                       spc_var = NULL, 
                       birthdat_var = "datebirth.1", 
                       lifedat_var = "datedeath.1",
                       use_lifedatmin = FALSE, 
                       check = TRUE, 
                       as_labelled_factor = FALSE)
                       
}
