% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\docType{methods}
\name{ev}
\alias{ev}
\alias{ev,mrgmod-method}
\alias{ev,missing-method}
\alias{ev,ev-method}
\title{Event objects for simulating PK and other interventions}
\usage{
ev(x, ...)

\S4method{ev}{mrgmod}(x, object = NULL, ...)

\S4method{ev}{missing}(time = 0, amt = 0, evid = 1, cmt = 1,
  ID = numeric(0), replicate = TRUE, until = NULL, tinf = NULL,
  realize_addl = FALSE, ...)

\S4method{ev}{ev}(x, realize_addl = FALSE, ...)
}
\arguments{
\item{x}{a model object}

\item{...}{other items to be incorporated into the event object; see 
details}

\item{object}{passed to show}

\item{time}{event time}

\item{amt}{dose amount}

\item{evid}{event ID}

\item{cmt}{compartment}

\item{ID}{subject ID}

\item{replicate}{logical; if \code{TRUE}, events will be replicated for 
each individual in \code{ID}}

\item{until}{the expected maximum \bold{observation} time for this regimen}

\item{tinf}{infusion time; if greater than zero, then the \code{rate} item 
will be derived as \code{amt/tinf}}

\item{realize_addl}{if \code{FALSE} (default), no change to \code{addl} 
doses.  If \code{TRUE}, \code{addl} doses are made explicit with 
\code{\link{realize_addl}}}
}
\value{
events object
}
\description{
An event object specifies dosing or other interventions that get implemented
during simulation. Event objects do similar things as \code{\link{data_set}}, 
but simpler and quicker.
}
\details{
\itemize{
\item Required items in events objects include 
\code{time}, \code{amt}, \code{evid} and \code{cmt}.
\item If not supplied, \code{evid} is assumed to be 1.
\item If not supplied, \code{cmt}  is assumed to be 1.
\item If not supplied, \code{time} is assumed to be 0.
\item If \code{amt} is not supplied, an error will be generated.
\item If \code{total} is supplied, then \code{addl} will be set 
to \code{total} - 1.
\item Other items can include \code{ii}, \code{ss}, and \code{addl}
(see \code{\link{data_set}} for details on all of these items).
\item \code{ID} may be specified as a vector.
\item If replicate is \code{TRUE} (default), then the events 
regimen is replicated for each \code{ID}; otherwise, the number of
event rows must match the number of \code{ID}s entered
}
}
\examples{
mod <- mrgsolve:::house()

mod <- mod \%>\% ev(amt=1000, time=0, cmt=1)

loading <- ev(time=0, cmt=1, amt=1000)

maint <- ev(time=12, cmt=1, amt=500, ii=12, addl=10)

c(loading, maint)

loading$time

}
\seealso{
\code{\link{ev_rep}}, \code{\link{ev_days}}, 
\code{\link{ev_repeat}}, \code{\link{ev_assign}},
\code{\link{ev_seq}}, \code{\link{mutate.ev}},
\code{\link{as.ev}}, \code{\link{ev_methods}}
}
