% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dplot}
\alias{dplot}
\alias{cplot}
\title{Plotting functions for lattice data}
\usage{
dplot(Z, legend = FALSE)

cplot(Y, legend = TRUE)
}
\arguments{
\item{Z}{A \code{matrix} object with integers only.}

\item{legend}{\code{logical} indicating whether a legend should be included or not.}

\item{Y}{A \code{matrix} object with continuous values.}
}
\value{
a \code{ggplot} object.
}
\description{
\code{dplot()} and \code{cplot()} are functions for plotting lattice data.
They are an alternative to base R's \code{image()} function using \code{ggplot2}
instead.
\code{dplot} is used for discrete data and \code{cplot} for continuous data, they only
differ in the fact that pixel values are treated as a factor in \code{dplot},
therefore, a discrete scale is used.
}
\details{
Since returns a \code{ggplot} object, other layers can be added to it
using the usual \code{ggplot2} syntax in order to modify any aspect of the plot.

The data frame used to create the object has columns named \code{x}, \code{y} and
\code{value}, which are mapped to \code{x}, \code{y} and \code{fill}, respectively, used
with \code{geom_tile()}.
}
\examples{
# Plotting discrete data
dplot(Z_potts)

#Making it continuous
cplot(Z_potts + rnorm(length(Z_potts)))

#Adding extra ggplot layers
library(ggplot2)
dplot(Z_potts) + ggtitle("This is a title")
dplot(Z_potts, legend = TRUE) + scale_fill_brewer(palette = "Set1")


}
\author{
Victor Freguglia
}
