% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_names.R
\name{mr_names}
\alias{mr_names}
\title{Get region names}
\usage{
mr_names(...)
}
\arguments{
\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame, or tibble, of class tbl_df (basically, a compact data.frame),
with slots:
\itemize{
 \item name (character) - name of the region, which is a combination of the
 name_first and name_second, e.g., Morocco:elevation_10m
 \item title (character) - title for the region
 \item name_first (character) - first part of the name, e.g., Morocco
 \item name_second (character) - second part of the name, e.g., elevation_10m
}
}
\description{
Get region names
}
\examples{
\dontrun{
# mr_names gives a tidy data.frame
(res <- mr_names())

# index to any given column
res$name

# get unique, sorted first names
sort(unique(res$name_first))

# get unique, sorted second names
sort(unique(res$name_second))

# get titles
res$title
}
}

