% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenQsphere.R
\name{eigenQsphere}
\alias{eigenQsphere}
\title{Generate eigenvalues of precision matrix Q on the surface of a sphere.}
\usage{
eigenQsphere(phimin, phimax, mm, nn)
}
\arguments{
\item{phimin}{Polar angle minimum.}

\item{phimax}{Polar angle maximum.}

\item{mm}{Number of rows of precision matrix Q.}

\item{nn}{Number of columns of precision matrix Q.}
}
\value{
A list containing 2 elements: 
\itemize{
    \item eigval Row vector containing the eigenvalues of Q. 
    \item eigvec Matrix containing the eigenvectors of Q as columns. 
}
}
\description{
The eigenvalues of the precision matrix Q with dimension (\code{mm}, \code{nn}) 
and polar angle limits \code{phimin}, \code{phimax} are calculated.
}
\details{
The corresponding function for data on a grid is \code{ \link{eigenLaplace}}.
}
\examples{
eig_out <- eigenQsphere(phimin = 180/10, phimax = 180 - 180/10, mm = 10, nn = 20)

}
