% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvmr_egger_rjags.R
\name{mvmr_egger_rjags}
\alias{mvmr_egger_rjags}
\title{Bayesian implementation of the MVMR-Egger model with choice of prior distributions fitted using JAGS.}
\usage{
mvmr_egger_rjags(
  object,
  prior = "default",
  betaprior = "",
  sigmaprior = "",
  orientate = 1,
  n.chains = 3,
  n.burn = 1000,
  n.iter = 5000,
  seed = NULL,
  rho = 0.5,
  ...
)
}
\arguments{
\item{object}{A data object of class \code{\link{mvmr_format}}.}

\item{prior}{A character string for selecting the prior distributions;
\itemize{
\item \code{"default"} selects a non-informative set of priors;
\item \code{"weak"} selects weakly informative priors;
\item \code{"pseudo"} selects a pseudo-horseshoe prior on the causal effect;
}}

\item{betaprior}{A character string in JAGS syntax to allow a user defined prior for the causal effect.}

\item{sigmaprior}{A character string in JAGS syntax to allow a user defined prior for the residual standard deviation.}

\item{orientate}{Numeric value to indicate the oriented exposure}

\item{n.chains}{Numeric indicating the number of chains used in the MCMC estimation, the default is \code{3} chains.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian MCMC estimation. The default is \code{1000} samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian MCMC estimation. The default is \code{5000} iterations.}

\item{seed}{Numeric indicating the random number seed. The default is the rjags default.}

\item{rho}{Numeric indicating the correlation coefficient input into the joint prior distribution. The default value is \code{0.5}.}

\item{...}{Additional arguments passed through to \code{\link[rjags:jags.model]{rjags::jags.model()}}.}
}
\value{
An object of class \code{mveggerjags} containing the following components:
if (requireNamespace("rjags", quietly = TRUE)) {
\item{AvgPleio}{The mean of the simulated pleiotropic effect}
\item{CausalEffect}{The mean of the simulated causal effect}
\item{StandardError}{Standard deviation of the simulated causal effect}
\item{sigma}{The value of the residual standard deviation}
\item{CredibleInterval}{The credible interval for the causal effect, which includes the lower (2.5\%), median (50\%) and upper intervals (97.5\%)}
\item{samples}{Output of the Bayesian MCMC samples}
\item{Priors}{The specified priors}
}
}
\description{
Bayesian implementation of the MVMR-Egger model with choice of prior distributions fitted using JAGS.
}
\examples{

\dontrun{
if (requireNamespace("rjags", quietly = TRUE)) {
dat <- mvmr_format(rsid = dodata$rsid,
         xbeta = cbind(dodata$ldlcbeta,dodata$hdlcbeta,dodata$tgbeta),
         ybeta = dodata$chdbeta,
         xse = cbind(dodata$ldlcse,dodata$hdlcse,dodata$tgse),
         yse = dodata$chdse)

fit <- mvmr_egger_rjags(dat)
summary(fit)
plot(fit$samples)
# 90\% credible interval
fitdf <- do.call(rbind.data.frame, fit$samples)
cri90 <- sapply(fitdf, quantile, probs = c(0.05, 0.95))
print(cri90)
}
}
}
\references{
Bowden et. al., Mendelian randomization with invalid instruments: effect estimation and bias detection through Egger regression. International Journal of Epidemiology 2015. 44(2): p. 512-525. \doi{10.1093/ije/dyv080}
}
