#' Convert an object of class MRInput from the MendelianRandomization package to the mrbayes mr_format class
#'
#' Creates a data.frame with class `mr_format` from an object of class `MRInput` generated by [`MendelianRandomization::mr_input`].
#'
#' @param dat Object from [`MendelianRandomization::mr_input`].
#'
#' @export
#' @return Object of class `mr_format`, the mrbayes format
#' @examples
#' if (requireNamespace("MendelianRandomization", quietly = TRUE)) {
#' dat <- MendelianRandomization::mr_input(bx = bmi_insulin$beta.exposure,
#'                                         bxse = bmi_insulin$se.exposure,
#'                                         by = bmi_insulin$beta.outcome,
#'                                         byse = bmi_insulin$se.outcome,
#'                                         snps = bmi_insulin$rsid)
#' dat <- mrinput_mr_format(dat)
#' head(dat)
#' class(dat)
#' }
mrinput_mr_format <- function(dat) {
  if (!("MRInput" %in% class(dat))) {
    stop('The class of the input data object must be "MRInput"')
  }

  out <- mr_format(xbeta = dat@betaX,
                   ybeta = dat@betaY,
                   xse = dat@betaXse,
                   yse = dat@betaYse,
                   rsid = dat@snps)
  out
}
