% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Upset_list.R
\name{get_Upset_list}
\alias{get_Upset_list}
\title{Generate Upset list}
\usage{
get_Upset_list(
  input_list,
  level = c("Precursor.IDs", "Peptide.IDs", "Protein.IDs", "ProteinGroup.IDs"),
  percentage_runs = 100,
  flowTraceR = FALSE,
  remove_traceR_unknownMods = FALSE
)
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}

\item{level}{Character string. Choose between "Precursor.IDs", "Peptide.IDs", "Protein.IDs", "ProteinGroup.IDs". Default is "Precursor.IDs".}

\item{percentage_runs}{Number. Percentage of appearance in runs. 100 means: Identification is present in 100\% of runs. Default is 100.}

\item{flowTraceR}{Logical. If FALSE no level conversion is applied. Useful for inter-software comparisons. Default is FALSE.}

\item{remove_traceR_unknownMods}{Logical. If FALSE no unknown Modifications are filtered out. Only applies if flowTraceR is set to TRUE. Default is FALSE.}
}
\value{
This function returns a list for each analysis with respective level information.
}
\description{
Generate a list as input for Upset plot
}
\details{
An input is generated for Upset plotting for either precursor-, peptide-, protein- or proteingroup-level. For inter-software comparisons flowTraceR is integrated.
}
\examples{
# Load libraries
library(tibble)
library(magrittr)
library(stringr)

# Example data
data <- list(
DIANN = list(
 filename = "B",
 software = "DIA-NN",
 data = list(
   "DIA-NN" = tibble::tibble(
     Run_mpwR = rep(c("A","B"), times = 10),
     Precursor.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
     Protein.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
     Peptide.IDs_mpwR = rep(c("A", "A", "B", "B", "C"), each = 4),
     ProteinGroup.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4)
   )
 )
),
Spectronaut = list(
 filename = "C",
 software = "Spectronaut",
 data = list(
   "Spectronaut" = tibble::tibble(
     Run_mpwR = rep(c("A","B"), times = 15),
     Precursor.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 6),
     Peptide.IDs_mpwR = rep(c("A", "A", "B", "B", "C"), each = 6),
     ProteinGroup.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 6)
   )
 )
)
)

# Result
output <- get_Upset_list(
  input_list = data,
  level = "Precursor.IDs"
)
}
\author{
Oliver Kardell
}
