% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp2sp.R
\name{mp2sp}
\alias{mp2sp}
\title{Create a SpatialPointsDataFrame describing Metapop population centroids}
\usage{
mp2sp(mp, coords, start, s_p4s, t_p4s)
}
\arguments{
\item{mp}{A RAMAS Metapop .mp file containing simulation results.}

\item{coords}{An object containing population coordinates. This object can be
created by using \code{\link{mp2xy}}}

\item{start}{The value of the first timestep. If timesteps are not in 
increments of 1, it may be best to use \code{start=1}, in which case 'time'
in the resulting shapefile's attribute table will refer to the timestep 
number.}

\item{s_p4s}{(Optional) The coordinate reference system of the source
cordinates given in \code{coords}. These can be supplied as a \code{CRS} 
object or as a proj4 string.}

\item{t_p4s}{(Optional) The target coordinate reference system to which
coordinates will be projected, if supplied. These can be supplied as a
\code{CRS} object or as a proj4 string.}
}
\value{
A \code{SpatialPointsDataFrame}.
}
\description{
Create a \code{SpatialPointsDataFrame} representing the centroid of each
population, with attributes: \code{pop} (population name), \code{time} (the
time step), and \code{N} (the mean population size).
}
\examples{
mp <- system.file('example.mp', package='mptools')
r <- system.file('example_001.tif', package='mptools')
coords <- mp2xy(mp, r, 9.975)
spdf <- mp2sp(mp, coords, start=2000)
spdf
}
\seealso{
\code{\link{mp2xy}}
}
\keyword{spatial}

