\docType{package}
\name{mpoly}
\alias{mpoly}
\alias{mpoly-package}
\alias{package-mpoly}
\title{Multivariate polynomials in R.}
\usage{
mpoly(list, varorder)
}
\arguments{
  \item{list}{a list from which to construct an mpoly
  object}

  \item{varorder}{(optional) a character vector setting the
  intrinsic variable order of the polynomial}
}
\value{
Object of class mpoly.
}
\description{
A package for symbolic computation and more with
multivariate polynomials

mpoly is the most basic function used to create objects of
class mpoly. However, it is not a general purpose function;
for that see mp.
}
\examples{
list <- list(
  c(x = 1, coef = 1, y = 0),
  c(x = 0, y = 1, coef = 2),
  c(y = 1, coef = -6),
  c(z = 1, coef = -3, x = 2),
  c(x = 1, coef = 0, x = 3),
  c(t = 1, coef = 4, t = 2, y = 4),
  c(coef = 5),
  c(coef = -5)
)

mpoly(list)
mpoly(list, varorder = c('y', 'z', 't', 'x'))

list <- list(  c(x = 5, x = 2, coef = 5, coef = 6, y = 0) )
mpoly(list)

# ERROR CHECKS (in order)
# mpoly(1:5)
# mpoly(list(c(x = 'a', coef = 1)))
# mpoly(list(c(x = 1,     1, coef = 2)))
# mpoly(list(c(x = 1, y = 1)))
# mpoly(list(c(x = 1, y = 1.5, coef = 2)))
# mpoly(list(c(x = 1, y = -2, coef = 2)))
# mpoly(list(c(x = 1, y = 2, coef = 2)), varorder = 'x')
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\code{\link{mp}}
}

