% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import m-Path Sense files into a database}
\usage{
import(
  path = getwd(),
  db,
  sensors = NULL,
  batch_size = 24,
  backend = "RSQLite",
  recursive = TRUE,
  dbname = deprecated(),
  overwrite_db = deprecated(),
  parallel = deprecated()
)
}
\arguments{
\item{path}{The path to the file directory}

\item{db}{Valid database connection.}

\item{sensors}{Select one or multiple sensors as in \code{\link[mpathsenser]{sensors}}. Leave
NULL to extract all sensor data.}

\item{batch_size}{The number of files that are to be processed in a single batch.}

\item{backend}{Name of the database backend that is used. Currently, only RSQLite is supported.}

\item{recursive}{Should the listing recurse into directories?}

\item{dbname}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: Creating new databases on the fly has been
deprecated as it is better to separate the two functions. You must now create a new database
using \code{\link[mpathsenser]{create_db}} or reuse an existing one.}

\item{overwrite_db}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: This argument was used when database
creation in \code{import} was still supported. As this functionality is deprecated,
\code{overwrite_db} is now ignored and will be removed in future versions.}

\item{parallel}{A value that indicates whether to do reading in and processing in parallel. If
this argument is a number, this indicates the number of workers that will be used.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: As functions should not modify the user's workspace,
directly toggling parallel support has been deprecated. Please use
\code{\link[future]{plan}("multisession")} before calling this function to use multiple
workers.}
}
\value{
A message indicating how many files were imported. Imported database can be reopened
using \link[mpathsenser]{open_db}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Import JSON files from m-Path Sense into a structured database. This function is the bread and
butter of this package, as it creates (or rather fills) the database that most of the other
functions in this package use.
}
\details{
\code{import} allows you to specify which sensors to import (even though there may be
more in the files) and it also allows batching for a speedier writing process. If processing in
parallel is active, it is recommended that \code{batch_size} be a scalar multiple of the number
of CPU cores the parallel cluster can use. If a single JSON file in the batch causes and error,
the batch is terminated (but not the function) and it is up to the user to fix the file. This
means that if \code{batch_size} is large, many files will not be processed. Set
\code{batch_size} to 1 for sequential (one-by-one) file processing.

Currently, only SQLite is supported as a backend. Due to its concurrency restriction, the
\code{parallel} option is disabled. To get an indication of the progress so far, set one of the
\link[progressr]{handlers} using the \code{progressr} package, e.g.
\code{progressr::handlers(global = TRUE)} and \code{progressr::handlers('progress')}.
}
\section{Parallel}{
 This function supports parallel processing in the sense that it is able to
distribute it's computation load among multiple workers. To make use of this functionality, run
\code{\link[future]{plan}("multisession")} before calling this function.
}

\section{Progress}{
 You can be updated of the progress of this function by using the
\code{\link[progressr]{progress}} package. See \code{progressr}'s
\href{https://cran.r-project.org/package=progressr/vignettes/progressr-intro.html}{vignette} on
how to subscribe to these updates.
}

