\name{summary.mpqtl}
\alias{summary.mpqtl}
\title{Summary of mpqtl object}
\usage{
  \method{summary}{mpqtl} (object, ...)
}
\arguments{
  \item{object}{Object of class \code{mpqtl}}

  \item{...}{Additional arguments}
}
\value{
  Table with rows for each QTL detected: Column 1 is the
  chromosome where the QTL was detected Column 2 is the
  position where the QTL was detected on the chromosome
  Columns 3 and 4 are the flanking markers for the QTL
  Columns 5, 6, 7 and 8 are the effect estimates for the
  founders Column 9 is the Wald test statistic for the
  overall test at that position Column 10 is the p-value
  for the test statistic
}
\description{
  Prints a summary of the detected QTL
}
\examples{
sim.map <- sim.map(len=rep(100, 2), n.mar=11, include.x=FALSE, eq.spacing=TRUE)
sim.ped <- sim.mpped(4, 1, 500, 6, 1)
sim.dat <- sim.mpcross(map=sim.map, pedigree=sim.ped, qtl=matrix(data=c(1, 10, .4, 0, 0, 0, 1, 70, 0, .35, 0, 0), nrow=2, ncol=6, byrow=TRUE), seed=1)
mpp.dat <- mpprob(sim.dat, program="qtl", step=2)
mpq.dat <- mpIM(object=mpp.dat, ncov=0, thr=1, responsename="pheno")
summary(mpq.dat)
}
\seealso{
  \code{\link[mpMap]{mpIM}},
  \code{\link[mpMap]{plot.mpqtl}}
}

