% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWindEstimates.R
\docType{methods}
\name{getWindEstimates}
\alias{getWindEstimates}
\alias{getWindEstimates,Move,missing-method}
\alias{getWindEstimates,MoveStack,missing-method}
\alias{getWindEstimates,data.frame,POSIXct-method}
\title{Title}
\usage{
getWindEstimates(data, timestamps, ...)

\S4method{getWindEstimates}{MoveStack,missing}(data, timestamps, ...)

\S4method{getWindEstimates}{Move,missing}(data, timestamps, ...)

\S4method{getWindEstimates}{data.frame,POSIXct}(data, timestamps,
  windowSize = 29, phi = 0.5, isFocalPoint = function(i, ts) {     TRUE },
  isSamplingRegular = 1,
  hasVariationInHeadingFunction = getDefaultIsThermallingFunction(360),
  columnNamesWind = c("estimationSuccessful", "residualVarAirspeed", "windX",
  "windY", "windVarX", "windVarY", "windCovarXY", "windVarMax",
  "isThermalling"), ...)
}
\arguments{
\item{data}{Move object, MoveStack or data.frame containing wind speeds}

\item{timestamps}{timestamps of the speed observations}

\item{...}{other possible arguments currently nothing else is implented}

\item{windowSize}{a numeric vector of length 1 or 2, if length 1 it is the size of the focal window data will be assigned to the central location. If length 2 the window size is \code{sum(windowSize)+1)} and the first element is the number of location before the focal locations, the second is the number of locations after the focal location.}

\item{phi}{todo}

\item{isFocalPoint}{todo}

\item{isSamplingRegular}{either a function that determines based on a vector of timestamps if the sampling interval is regular or a numeric value that corresponds to the time interval between observations in the dataset that is regular}

\item{hasVariationInHeadingFunction}{todo}

\item{columnNamesWind}{todo}
}
\value{
a Move object, dataframe or a MoveStack depending on input
}
\description{
Title
}
\examples{
data("storks")
# run example for reduced dataset
windEst<-getWindEstimates(storks[format(timestamps(storks),"\%H")=="12",][[2:3]])
windEst<-spTransform(windEst, center=TRUE)
plot(windEst)
# only plot few arrows of estimates
s<-windEst$estimationSuccessful & format(timestamps(windEst), "\%S")=='00'
# enlarge arrows 30 times
arrows(coordinates(windEst)[s,1],coordinates(windEst)[s,2], 
   coordinates(windEst)[s,1]+ windEst$windX[s]*30, 
   coordinates(windEst)[s,2]+windEst$windY[s]*30)
}

