% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_libraries.R
\name{get_libraries}
\alias{get_libraries}
\alias{get_imconvert}
\title{Detect and/or download and install extern system libraries needed by moveVis}
\usage{
get_libraries(lib.tool = "all", dir = "none", ...)

get_imconvert(dir = "auto")
}
\arguments{
\item{lib.tool}{character. Vector of libraries to look for. This can be either 'convert', 'ffmpeg', 'avconv' or a combination. Default is "all" to check for all possible libraries.}

\item{dir}{character. Directory were to download, unzip and install ImageMagick. If set to "auto", a temporary directory is used. Default is "none", which will cause no automatic installation.}

\item{...}{additional arguments. Currently not used.}
}
\value{
A character vector including all found commands or directories to the needed tools of the requested libraries. The return can serve as \code{conv_dir} input to the \code{animate_move} function.
}
\description{
\code{get_libraries} trys to detect the libraries on your system that are needed by moveVis to be able to deal with different output file formats. get_libraries() searches for'convert' form the ImageMagick library (needed for .gif support), 'ffmpeg' from the FFmpeg library or 'avconv' from the 'libav-tools' library (both needed for video support).
You can execute get_libraries() to make sure, these libraries are correctly installed on your system. It is recommended to have ImageMagick including 'convert' and FFmpeg including 'ffmpeg' installed to gain support of all available output file formats. The function's return can serve as \code{conv_dir} input to the animate_move() function.
 
\code{get_imconvert} is an alias function of \code{get_libraries} inlcuded for compatibility reasons that does the same as \code{get_libraries}, but is only checking for the \code{convert} tool of ImageMagick. It is recommended to use \code{get_libraries} instead.
}
\details{
The following tools and libraries are needed by moveVis:
\itemize{
  \item the \code{convert} tool of ImageMagick to support the GIF format
  \item the \code{ffmpeg} tool of FFmpeg to support video formats
  \item alternatively to ffmpeg, the \code{avconv} tool of libav-tools to support video formats.
}
It is recommmended to have both ImageMagick and one of the mentioned video libraries installed to be able to create all output formats with the animate_move() function (see argument \code{out_format} of \link{animate_move})

If you are running Windows, the function can download and either temporarily or permanently install ImageMagick
on your Windows system in case that no existing installation can be found. For FFmpeg or libav, a download link will be provided.

If you are running Linux, the function provides a root permission requiring command to be executed once by the user in the terminal
to install ImageMagick, FFmpeg or libav, if not installed. On standard Ubuntu distributions, ImageMagick and FFmpeg belong to the preinstalled packages by default.
If you are running macOS (former OSX), manual installation is necessary or installation via a package manager such as 'brew'.

You can install the necessary libraries manually and then run get_libraries to just identify the needed commands:
\itemize{
  \item ImageMagick: \url{https://www.imagemagick.org/script/download.php})
  \item FFmpeg from \url{https://www.ffmpeg.org/download.html}
  \item libav from \url{https://libav.org/download/}  
}
}
\examples{
#conv_dir of the animate_move() function
conv_dir <- get_libraries()

}
\seealso{
\code{\link{animate_move}}
}
\author{
Jakob Schwalb-Willmann
}
