% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_stack.R
\name{mt_stack}
\alias{mt_stack}
\title{Combine multiple \code{move2} objects into one}
\usage{
mt_stack(
  ...,
  .track_combine = c("check_unique", "merge", "rename"),
  .track_id_repair = c("unique", "universal", "unique_quiet", "universal_quiet")
)
}
\arguments{
\item{...}{Either a list of \code{move2} objects to combine or the objects to combine as separate arguments}

\item{.track_combine}{A character string indicating the way duplicated tracks should be resolved. By default ("check_unique")
an error is raised if different objects contain tracks with the same name. With "merge" tracks with the same name can be merged, and with "rename" non unique tracks can be renamed.}

\item{.track_id_repair}{The way in which names should be repaired when renaming is done, see \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more details on each option}
}
\value{
An object of the class \code{move2}
}
\description{
This function does a similar job to \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}, when columns are missing of any of the
objects, they are added.
}
\details{
An attempt is made to combine objects that have a different \code{track_id_column} or \code{time_column}, however this is
only done if it can be done without data loss.

When objects are too different (e.g. different projection or different types of timestamps that cannot
be combine) and error is raised.
When tracks have the same name in different objects to combine this will results in an error.

When merging several tracks, the track attributes of these tracks are also combined.
This is done by creating a lists within each column. See examples in \code{\link[=mt_set_track_id]{mt_set_track_id()}}.
}
\examples{
a <- mt_sim_brownian_motion(1:2, tracks = c("a", "b"))
b <- mt_sim_brownian_motion(1:2, tracks = c("g", "h"))
mt_stack(a, b)

## having different columns does not cause problems
a$extra_data <- 1:nrow(a)
mt_stack(list(a, b))

## Combining different datasets works
fishers <- mt_read(mt_example(), n_max = 100, col_select = c(
  "eobs:used-time-to-get-fix",
  "location-long", "location-lat", "timestamp", "individual-local-identifier"
))

## Objects to stack need to have the same CRS, use either st_set_crs
## or st_transform depending what is appropriate
random_track <- mt_sim_brownian_motion(
  t = as.POSIXct("1970-1-1") + 1:3,
  tracks = factor(letters[1:2])
) |> sf::st_set_crs(4326)
mt_time(random_track) <- "timestamp"
mt_stack(
  random_track,
  fishers
)

\donttest{
if (requireNamespace("units")) {
  males <- tail(filter_track_data(
    fishers,
    grepl("M", `individual-local-identifier`)
  ), 5)
  females <- filter_track_data(
    fishers,
    grepl("F", `individual-local-identifier`)
  )
  females$`eobs:used-time-to-get-fix` <- units::set_units(
    females$`eobs:used-time-to-get-fix`,
    "hours"
  )
  females <- tail(females, 5)
  ## combining with different units works correctly (units are unified with correct conversion)
  mt_stack(males, females)
}
}
}
\seealso{
rbind
}
