% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movement_angle.R
\name{mt_movement_angle}
\alias{mt_movement_angle}
\title{Calculate initial movement angle.}
\usage{
mt_movement_angle(data, use = "trajectories", save_as = "measures",
  ima_percentile = 0.2, show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details). Alternatively, a trajectory 
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be 
used.}

\item{save_as}{a character string specifying where the calculated measures
should be stored.}

\item{ima_percentile}{a decimal value. The initial movement angle will be
calculated at the respective percentile .}

\item{show_progress}{logical indicating whether function should report on its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}).
  
  If a data.frame with label specified in \code{save_as} (by default 
  "measures") already exists, the \code{IMA}, \code{IMA_time}, and \code{IMD}
  values (see Details) are added as additional columns (by merging them using
  the \link{mt_id} variable).
  
  If not, an additional \link{data.frame} will be added.
  
  If a trajectory array was provided directly as \code{data}, only the
  data.frame will be returned.
}
\description{
Calculate initial movement angle (IMA) and related measures for each
trajectory.
}
\details{
The \code{IMA} is based on the initial movement angle used by Buetti
and Kerzel (2009). In their experiment, actual hand movements were recorded 
and the \code{IMA} was the angle between the position of the hand and the 
axis running through the correct response location at a specific point in 
time (in the original study, one fifth of the trial). Adapting this to the 
mouse-tracking setup, the \code{IMA} is the angle between the idealized
response trajectory (straight line) and the movement from the starting point
in the trial to the position of the mouse at the specified percentile. If
this position is above the idealized response trajectory, the angle has a
positive value. If it is below the idealized response trajectory, the angle
has a negative value.

The \code{IMA} is calculated for a specific percentile of the trial, which 
can be adjusted using \code{ima_percentile} (e.g., \code{ima_percentile=0.2}
to correspond to the study by Buetti and Kerzel, 2009). In addition, the
timestamp of the specified percentile is also reported (\code{IMA_time}).
Besides, the perpendicular deviation from the direct path at the specified
percentile is included (\code{IMD}).
}
\examples{
mt_example <- mt_calculate_measures(mt_example)
mt_example <- mt_movement_angle(mt_example,
  use="trajectories", save_as="measures",
  ima_percentile=0.20)

}
\references{
Buetti, S., & Kerzel, D. (2009). Conflicts during response 
  selection affect response programming: Reactions toward the source of 
  stimulation. \emph{Journal of Experimental Psychology: Human Perception and
  Performance, 35}(3), 816-834.
}
\seealso{
\link{mt_calculate_measures} for calculating other mouse-tracking
measures.
}

