% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_align_start}
\alias{mt_align_start}
\title{Align start position of trajectories.}
\usage{
mt_align_start(data, use = "trajectories", save_as = "trajectories",
  xpos_start = 0, ypos_start = 0, show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details). Alternatively, a trajectory 
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be 
used.}

\item{save_as}{a character string specifying where the resulting trajectory 
data should be stored.}

\item{xpos_start}{an integer specifying the value the first x-position should
have in each trial.}

\item{ypos_start}{an integer specifying the value the first y-position should
have in each trial.}

\item{show_progress}{logical indicating whether function should report on its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with aligned 
  trajectories. If the trajectory array was provided directly as \code{data},
  only the trajectory array will be returned.
}
\description{
Adjust trajectories so that all trajectories have the same start position.
}
\examples{
mt_example <- mt_align_start(mt_example,
  xpos_start=0, ypos_start=0)

}
\seealso{
\link{mt_space_normalize} for space normalizing trajectories.

\link{mt_remap_symmetric} for remapping trajectories.
}

