\name{as.rateData}
\alias{as.rateData}
\title{
Conversion among data and phylogeny objects}
\description{
Function to generate a "rateData" object containing the discrete explanatory variable, continuous 
response variable and set of variance co-variance matrices. It loads the trait data and removes 
species with missing data from the data and vcv matrix. 

\code{as.rateData} requires either a set of matrices in rateMatrix format created using 
\code{as.rateMatrix} or, if no rateMatrix object is input then it requires a phylogeny in "phylo" 
format. If  a "phylo" object is used  \code{as.rateData} will call \code{as.rateMatrix} internally.
\code{as.rateMatrix} calls the "ape" function \code{vcv.phylo} multiple times and this can be slow 
for large phylogenies. It will often be more efficient to use \code{as.rateMatrix} first to create 
a "rateMatrix" object to pass to \code{as.rateData}, particularly if there are many response traits
of interest to be fitted to the same phylogeny and set of reconstructed ancestral states.
}

\usage{
as.rateData(y, x, rateMatrix = NULL, phy, data, meserr=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{
The response variable - typically a continuous trait.}
  \item{x}{
The explanatory (discrete) variable used to define the hypothesised rate categories.}
  \item{rateMatrix}{
An object of class "rateMatrix".}
  \item{phy}{
An object of class "phylo" (see ape package).}
  \item{data}{
A data frame containing (minimally) the x and y variables as columns with species names as 
rownames.}
  \item{meserr}{
Measurement error (should be a column in the data frame).}
}

\value{

\item{rateData }{An object of class "rateData" which is a list containing the response (y) and 
explanatory (x) variable along with a list of variance-covaraince matrices. }

}
\references{
Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments
and island effects. Evolution 63, 2017-2030.}
\author{
Gavin Thomas}


%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{

## Read in phylogeny and data from Thomas et al. (2009)
data(anolis.tree)
data(anolis.data)


# Not run
## Convert data to class rateData with a rateMatrix object as input
#anolis.rateMatrix <- as.rateMatrix(phy=anolis.tree, x=anolis.data$geo_ecomorph, data=anolis.data)

#anolis.rateData <- as.rateData(y=log10(anolis.data$Female_SVL), x=anolis.data$geo_ecomorph, 
#rateMatrix = anolis.rateMatrix, phy=NULL, data=anolis.data)  

## Convert data to class rateData with a phylo object as input 
#anolis.rateData <- as.rateData(y=anolis.data$Female_SVL, x=anolis.data$geo_ecomorph, 
#rateMatrix = NULL, phy=anolis.tree, data=anolis.data) 

}