% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifadjacency.R
\name{build_motif_adjacency_matrix}
\alias{build_motif_adjacency_matrix}
\title{Build a motif adjacency matrix}
\usage{
build_motif_adjacency_matrix(
  adj_mat,
  motif_name,
  motif_type = c("struc", "func"),
  mam_weight_type = c("unweighted", "mean", "poisson"),
  mam_method = c("sparse", "dense")
)
}
\arguments{
\item{adj_mat}{Adjacency matrix from which to build the motif
adjacency matrix.}

\item{motif_name}{Motif used for the motif adjacency matrix.}

\item{motif_type}{Type of motif adjacency matrix to build.
One of \code{"func"} or \code{"struc"}.}

\item{mam_weight_type}{The weighting scheme to use.
One of \code{"unweighted"}, \code{"mean"} or \code{"product"}.}

\item{mam_method}{Which formulation to use.
One of \code{"dense"} or \code{"sparse"}.
The sparse formulation avoids generating large dense matrices
so tends to be faster for large sparse graphs.}
}
\value{
A motif adjacency matrix.
}
\description{
Build a motif adjacency matrix from an adjacency matrix.
}
\details{
Entry (\emph{i}, \emph{j}) of a motif adjacency matrix is the
sum of the weights of all motifs containing both
nodes \emph{i} and \emph{j}.
The motif is specified by name and the type of motif instance can be one of:
\itemize{
  \item Functional: motifs should appear as subgraphs.
  \item Structural: motifs should appear as induced subgraphs.
}
The weighting scheme can be one of:
\itemize{
  \item Unweighted: the weight of any motif instance is one.
  \item Mean: the weight of any motif instance
    is the mean of its edge weights.
  \item Product: the weight of any motif instance
    is the product of its edge weights.
}
}
\examples{
adj_mat <- matrix(c(1:9), nrow = 3)
build_motif_adjacency_matrix(adj_mat, "M1", "func", "mean")
}
