% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapMirror.R
\name{morphomapMirror}
\alias{morphomapMirror}
\title{morphomapMirror}
\usage{
morphomapMirror(mesh)
}
\arguments{
\item{mesh}{object of class mesh3d}
}
\value{
mesh: object of class mesh3d
}
\description{
Mirror a long bone mesh along the yz plane
}
\examples{
\donttest{
#a left human femur bone
library(rgl)
data(HomFem38023)
lfem<-HomFem38023
rfem<-morphomapMirror(lfem)
open3d()
wire3d(lfem,col="green")
wire3d(rfem,col="red")
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
