% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{summary.morf}
\alias{summary.morf}
\title{Summary Method for morf Objects}
\usage{
\method{summary}{morf}(object, ...)
}
\arguments{
\item{object}{An \code{\link{morf}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Summarizes an \code{\link{morf}} object.
}
\description{
Summarizes an \code{\link{morf}} object.
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit morf.
forests <- morf(y, X)

## Summary.
summary(forests)

}
\seealso{
\code{\link{morf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
