% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_up.R
\name{combine_words}
\alias{combine_words}
\alias{combi_words}
\title{Combine words after morphological analysis}
\usage{
combine_words(df, combi, sep = "-")

combi_words(x, combi, sep = "-")
}
\arguments{
\item{df}{A dataframe including result of morphological analysis.}

\item{combi}{A string (combi_words()) or string vector (combine_words()) to combine words.}

\item{sep}{A string of separator of words}

\item{x}{A pair of string joining with "-"}
}
\value{
A data.frame with combined words.
}
\description{
Combine words after morphological analysis
}
\examples{
x <- letters[1:10]
combi <- c("b-c")
combi_words(x, combi)
expected <- c("a", "bc", NA, "d", "e", "f", "g", "h", "i", "j")
testthat::expect_equal(combi_words(x, combi), expected)

df <- unescape_utf(review_chamame) |> head(20)
combi <- unescape_utf(
           c("\\\\u751f\\\\u7269-\\\\u591a\\\\u69d8", "\\\\u8fb2\\\\u5730-\\\\u306f"       ,
             "\\\\u8fb2\\\\u7523-\\\\u7269"       , "\\\\u751f\\\\u7523-\\\\u3059\\\\u308b"))
combine_words(df, combi)

}
