% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdata.R
\docType{data}
\name{mods}
\alias{mods}
\title{Fitted models}
\source{
# RS_random is the result of running the following code:

data(Oak_phylo2)

presences <- Oak_phylo2$H11

destfile <- tempfile()

data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"

download.file(data.url, destfile)

load(destfile, verbose = TRUE)

r <- biostack$baseline[[1]]

## Background of the whole study area
bg <- backgroundGrid(r)

## Considering an unique background extent

RS_random <-pseudoAbsences(xy = presences, background = bg$xy, 
                           realizations = 5,
                           exclusion.buffer = 0.083*5, prevalence = -0.5, kmeans = FALSE)

fittedModels <- mopaTrain(y = RS_random, x = biostack$baseline, k = 10, 
                    algorithm = "mars")
                    
mods <- extractFromModel(models = fittedModels, value = "model")
}
\description{
List of fitted models as returned by functions \code{\link{mopaTrain}} and 
\code{\link{extractFromModel}}.
}
\keyword{records}
\keyword{xy}
