% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCSVMprofiling.R
\name{OCSVMprofiling}
\alias{OCSVMprofiling}
\title{Environmental profiling with One-Classification Support Vector Machine}
\usage{
OCSVMprofiling(xy, varstack, background = NULL, nu = 0.5)
}
\arguments{
\item{xy}{Data frame or list of data frames with coordinates (each row is a point)}

\item{varstack}{RasterStack of variables for modeling}

\item{background}{Object derived from function \code{\link[mopa]{backgroundGrid}}. If NULL (default),
the background is extracted from varstack.
Matrix or list of matrixes of the background xy coordinates in columns.}

\item{nu}{Parameter needed for one-classification \code{\link[e1071]{svm}}. 
Default is 0.5}
}
\value{
A list with two components:
  \item{absence }{Matrix or list of matrixes with xy coordinates predicted 
as absence}
\item{presence }{Matrix or list of matrixes with xy coordinates predicted as presence}
}
\description{
Presence-only modeling and classification of coordinates predicted as 
presence and absence
}
\details{
This function constitutes the 
first step from a three-step proccess to generate pseudo-absences, and is aimed at 
excluding the suitable areas for the species (xy records) from the background 
from which pseudo-absences are sampled.
}
\examples{
## Load presence data
data(Oak_phylo2)

## Load climate data
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Spatial reference
projection(biostack$baseline) <- CRS("+proj=longlat +init=epsg:4326")
r <- biostack$baseline[[1]]
## Background of the whole study area
bg <- backgroundGrid(r)

## Environmental profiling
bg.profiled <- OCSVMprofiling(xy = Oak_phylo2, varstack = biostack$baseline, 
                              background = bg$xy)
## Plot
plot(bg.profiled$absence$H11, pch="*")
points(bg.profiled$presence$H11, pch="*", col= "pink")

}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\seealso{
\code{\link[e1071]{svm}}, \code{\link[mopa]{backgroundGrid}}
}
\author{
M. Iturbide
}
