% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_category.R
\name{define_question}
\alias{define_question}
\alias{define_question.question_category}
\title{Define question}
\usage{
define_question(qc, type, question, image, image_alt, answer, ...)

\method{define_question}{question_category}(
  qc,
  type = "",
  question = "",
  image = "",
  image_alt = "",
  answer = "",
  ...
)
}
\arguments{
\item{qc}{A \code{question_category} object.}

\item{type}{A string, question type (if needed).}

\item{question}{A string, statement of the question.}

\item{image}{A string, optional, image file to include in the question.}

\item{image_alt}{A string, description of the image to include in the question.}

\item{answer}{A string, correct answer to the question.}

\item{...}{A string, rest of the answers to the question.}
}
\value{
A \code{question_category}.
}
\description{
Define a question and the possible answers. The type of question is deduced.
}
\details{
If we include an image in the question, we must also include text in the \code{alt}
field associated with it.

After the correct answer, we can indicate as many answers as we want, if we do
not indicate all the parameters, we have to give each answer a parameter name
different from the rest of the parameter names.
}
\examples{

qc <- question_category(category = 'Initial test') |>
  define_question(
    question = 'What are the basic arithmetic operations?',
    answer = 'Addition, subtraction, multiplication and division.',
    a_1 = 'Addition and subtraction.',
    a_2 = 'Addition, subtraction, multiplication, division and square root.'
  )

}
\seealso{
Other question definition: 
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml}()},
\code{\link{generate_xml_file}()},
\code{\link{question_category}()}
}
\concept{question definition}
