% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reader.R
\name{read_bson}
\alias{read_bson}
\title{Standalone BSON reader}
\usage{
read_bson(file, as_json = FALSE, simplify = TRUE, verbose = interactive())
}
\arguments{
\item{file}{path or url to a bson file}

\item{as_json}{read data into json strings instead of R lists.}

\item{simplify}{should nested data get simplified into atomic vectors and
dataframes where possible? Only used for \code{as_json = FALSE}.}

\item{verbose}{print some progress output while reading}
}
\description{
Reads BSON data from a \code{mongoexport} dump file directly into R (if it can fit
in memory). This utility does not attempt to convert result into one big single
data.frame: the output is always a vector of length equal to total number of
documents in the collection.
}
\details{
It is enabled by default to simplify the individual data documents using the
same rules as \link[jsonlite:fromJSON]{jsonlite}. This converts nested lists into atomic
vectors and data frames when possible, which makes data easier to work with in R.

An alternative to this function is to import your BSON file into a local mongodb
server using the \link[=mongo]{mongo$import()} function. This requires little memory
and once data is in mongodb you can easily query and modify it.
}
\examples{
diamonds <- read_bson("https://jeroen.github.io/data/diamonds.bson")
length(diamonds)
}
