% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AICweights.R
\name{AICweights}
\alias{AICweights}
\title{Calculate Akaike information criterion model weights}
\usage{
AICweights(..., k = 2, n = NULL)
}
\arguments{
\item{...}{\code{\link{momentuHMM}}, \code{\link{HMMfits}}, or \code{\link{miHMM}} objects, to compare AIC weights of the different models.}

\item{k}{Penalty per parameter. Default: 2 ; for classical AIC.}

\item{n}{Optional sample size. If specified, the small sample correction AIC is used (i.e., \code{AICc = AIC + kp(p+1)/(n-p-1)} where p is the number of parameters).}
}
\value{
The AIC weights of the models. If multiple imputation objects are provided, 
then the mean model weights (and standard deviations) are provided.
}
\description{
Calculate Akaike information criterion model weights
}
\details{
\itemize{
\item Model objects must all be either of class \code{\link{momentuHMM}} or multiple imputation model objects (of class \code{\link{HMMfits}} and/or \code{\link{miHMM}}).

\item AIC is only valid for comparing models fitted to the same data. The data for each model fit must therefore be identical. For multiple imputation model objects, 
respective model fits must have identical data.}
}
\examples{

\dontrun{
# HMM specifications
nbStates <- 2
stepDist <- "gamma"
angleDist <- "vm"
mu0 <- c(20,70)
sigma0 <- c(10,30)
kappa0 <- c(1,1)
stepPar0 <- c(mu0,sigma0)
anglePar0 <- c(-pi/2,pi/2,kappa0)
formula <- ~cov1+cov2
                
# example$m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
mod1 <- fitHMM(example$m$data,nbStates=nbStates,dist=list(step=stepDist,angle=angleDist),
                Par0=list(step=stepPar0,angle=anglePar0),
                formula=~1,estAngleMean=list(angle=TRUE))

Par0 <- getPar0(mod1,formula=formula)                 
mod2 <- fitHMM(example$m$data,nbStates=nbStates,dist=list(step=stepDist,angle=angleDist),
                Par0=Par0$Par,beta0=Par0$beta,
                formula=formula,estAngleMean=list(angle=TRUE))
                
AICweights(mod1,mod2)
}

}
