% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNEbar.R
\name{DNEbar}
\alias{DNEbar}
\title{Plot advanced results of a DNE surface analysis}
\usage{
DNEbar(
  DNE_File,
  main = "",
  convexCol = "hotpink",
  concaveCol = "deepskyblue",
  type = "both",
  legendPos = "topright",
  legendInset = 0,
  las = 1,
  names.arg = "",
  cex.names = 1
)
}
\arguments{
\item{DNE_File}{An object that stores the output of the DNE()
function}

\item{main}{User's title for plot.}

\item{convexCol}{Color for the convex DNE total. Default='hotpink'}

\item{concaveCol}{Color for the concave DNE total. Default='deepskyblue'}

\item{type}{string to determine what parameters to plot. Default=both and
both concave and convex DNE totals will be plotted in stacked bar plot. See details}

\item{legendPos}{string to determine location of the legend. Default='topright'
see details.}

\item{legendInset}{numeric value determining how far to inset the legend from plot
boarder. Default=0}

\item{las}{logical indicating orientation of the x-axis labels for each bar plot. Enter either 1 or 2.}

\item{names.arg}{concatenated string of surface names for labels. If none supplied function will
pull names from the object itself.}

\item{cex.names}{Font size for the bar labels. Default is 1.}
}
\description{
a molaR plotting function
}
\details{
This function creates a stacked barplot of DNE values. It colors them according
to curve orientation, which is defined by the \code{kappa} parameter in \code{DNE()} function. If multiple
DNE objects are grouped together the barplot will return a set. When employed on a single
DNE object this will return a single stacked bar.

The argument \code{type} accepts either 'Concave' or 'Convex' to plot only concave or convex
DNE totals respectively. Default=NA and results in both totals being plotted in stacked barplot.

The argument \code{legendPos} is a string that determines the position of the legend. Default='topright'
but will accept any of the following keywords: 'bottomright', 'bottom', 'bottomleft', 'left', 'topleft', 'top',
'topright', 'right', or 'center'.
}
\examples{
DNEs <- list()
DNEs$Tooth <- DNE(Tooth)
DNEs$Hills <- DNE(Hills)
DNEbar(DNEs)
}
