% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_hego.R
\name{max_EHVI}
\alias{max_EHVI}
\title{max_EHVI: Maximization of the Expected Hypervolume Improvement criterion}
\usage{
max_EHVI(model, lower = rep(0, model@d), upper = rep(1, model@d),
  control = NULL, optimcontrol = NULL)
}
\arguments{
\item{model}{An object of class \code{\link{mkm}}.}

\item{lower}{Vector of lower bounds for the variables to be optimized over
(default: 0 with length \code{model@d}),}

\item{upper}{Vector of upper bounds for the variables to be optimized over
(default: 1 with length \code{model@d}),}

\item{control}{An optional list of control parameters, some of them passed to
the \code{\link[GPareto]{crit_EHI}} function. One can control:
\describe{
\item{\code{minimization}}{logical indicating if the EHVI is minimizing all
objectives (\code{TRUE}, by default) or maximizing all objectives
(\code{FALSE}). Mixed optimization is not currently accepted, if the user
needs it, the cost functions should be modified prior Kriging modeling
(i.e. inverting or mutilpying the optut by \code{-1}).}
\item{\code{paretoFront}}{object of class \code{\link{ps}} containing the
actual Pareto set. If not provided a Pareto set is built based on the
current feasible observations (\code{model@response[model@feasible,]}).}
\item{\code{nb.samp}}{number of random samples from the posterior distribution
 (with more than two objectives), default to 50, increasing gives more reliable
  results at the cost of longer computation time}
\item{\code{seed}}{seed used for the random samples (with more than two objectives);}
\item{\code{refPoint}}{reference point for Hypervolume Expected Improvement.
 If not provided, it is set to the maximum or minimum of each objective.}
 }}

\item{optimcontrol}{Optional list of control parameters passed to the
\code{\link[GenSA]{GenSA}} function. Please, note that the values are passed as
the \code{control} parameter inside the \code{GenSA} function (\code{genSA(control = optimcontrol)}).}
}
\value{
A list with components:
\describe{
 \item{\code{par}}{The best set of parameters found.}
 \item{\code{value}}{The value of expected hypervolume improvement at par.}
 }
}
\description{
Given an object of class \code{\link{mkm}} and a set of tuning parameters,
max_EHVI performs the maximization of the Expected Hypervolume Improvement
criterion and delivers the next point to be visited in an HEGO-like
procedure.
}
\examples{
# ------------------------
# The Nowacki Beam
# ------------------------
n <- 20
d <- 2
doe <- replicate(d,sample(0:n,n))/n
res <- t(apply(doe, 1, nowacki_beam, box = data.frame(b = c(10, 50), h = c(50, 250))))
model <- mkm(doe, res, modelcontrol = list(objective = 1:2, lower=c(0.1,0.1)))
max_EHVI(model)
}

