% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfR.fit.R
\name{moezipfR.fit}
\alias{AIC.moezipfR}
\alias{BIC.moezipfR}
\alias{coef.moezipfR}
\alias{fitted.moezipfR}
\alias{logLik.moezipfR}
\alias{moezipfR.fit}
\alias{plot.moezipfR}
\alias{print.moezipfR}
\alias{residuals.moezipfR}
\alias{summary.moezipfR}
\title{MOEZipf parameters estimation.}
\usage{
moezipfR.fit(data, init_alpha, init_beta, level = 0.95, ...)

\method{residuals}{moezipfR}(object, ...)

\method{fitted}{moezipfR}(object, ...)

\method{coef}{moezipfR}(object, ...)

\method{plot}{moezipfR}(x, ...)

\method{print}{moezipfR}(x, ...)

\method{summary}{moezipfR}(object, ...)

\method{logLik}{moezipfR}(object, ...)

\method{AIC}{moezipfR}(object, ...)

\method{BIC}{moezipfR}(object, ...)
}
\arguments{
\item{data}{Matrix of count data.}

\item{init_alpha}{Initial value of \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{init_beta}{Initial value of \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{level}{Confidence level used to calculate the intervals (default 0.95).}

\item{...}{Further arguments to the generic functions. In case of the function \emph{moezipfR.fit}
the extra arguments are passing to the \link{optim} function.}

\item{object}{An object from class "moezipfR" (output of \emph{moezipfR.fit} function).}

\item{x}{An object from class "moezipfR" (output of \emph{moezipfR.fit} function).}
}
\value{
Returns a \emph{moezipfR} object composed by the maximum likelihood parameter estimations,
their standard deviation, their confidence intervals and the log-likelihood value.
}
\description{
For a given count data set,  usually of the type of ranking data or frequencies of frequencies data, estimates the parameters of the MOEZipf distribution by means of the maximum likelihood
method.
}
\details{
The argument \code{data} is a matrix where, for each row, the first column contains a count,
and the second column contains its corresponding frequency.

The log-likelihood function is computed by means of the following equation:

\deqn{l(\alpha, \beta; x) = -\alpha \sum_{i = 1} ^m f_{a}(x_{i}) log(x_{i}) + N (log(\beta) + \log(\zeta(\alpha)))}
\deqn{ - \sum_{i = 1} ^m f_a(x_i) log[(\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x_i)(\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x_i + 1)))], }
where \eqn{N} is the sample size \eqn{N = \sum_{i = 1} ^m x_i f_a(x_i)}, \eqn{m} is the number of different values \eqn{x_{i}} in the sample,
and \eqn{f_{a}(x_i)} is the absolute frequency of \eqn{x_i}.

The function \emph{\link{optim}} is used to estimate the parameters.
}
\examples{
data <- rmoezipf(100, 2.5, 1.3)
data <- moezipfR.utils.getDataMatrix(data)
obj <- moezipfR.fit(data, 1.001, 0.001)
}
\seealso{
\code{\link{moezipfR.utils.getDataMatrix}}, \code{\link{moezipfR.utils.getInitialValues}}.
}

