% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depend.R
\name{depend}
\alias{depend}
\alias{depend.default}
\title{Declare dependencies of modules}
\usage{
depend(on, ...)

\method{depend}{default}(on, version = "any", libPath = NULL, ...)
}
\arguments{
\item{on}{(character) a package name}

\item{...}{arguments passed to \link{install.packages}}

\item{version}{(character) a version, defaults to 'any'}

\item{libPath}{(character | NULL) a path to the library (folder where
packages are installed)}
}
\value{
\code{TRUE} if dependency is available or successfully installed. An error if
  dependency can not be installed and is not available.
}
\description{
This function will check for a dependency and tries to make it available
if it is not. This is a generic function. Currently only a default method
exists which assumes a package name as argument. If a package is not
installed \code{depend} tries to install it.
}
\examples{
# Depend on certain R version
depend("base", "3.0.0")
# Depend on package version
depend("modules", "0.6.0")
}
