% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwmk.R
\name{pwmk}
\alias{pwmk}
\title{Mann-Kendall Test of Prewhitened Time Series Data in Presence of Serial Correlation Using the von Storch (1995) Approach}
\usage{
pwmk(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z-Value  - Z statistic after prewhitening

Sen's Slope  - Sen's slope for prewhitened series

old. Sen's Slope  - Sen's slope for original data series (x)

P-value  - P-value after prewhitening

S  - Mann-Kendall S statistic

Var(s) - Variance of S

Tau  - Mann-Kendall's Tau
}
\description{
When time series data are not random and influenced by autocorrelation, prewhitening the time series prior to application of trend test is suggested.
}
\details{
The lag-1 serial correlation coefficient is used for prewhitening.
}
\examples{
x<-c(Nile)
pwmk(x)

}
\references{
Kendall, M. (1975). Rank Correlation Methods. Griffin, London, 202 pp.

Kulkarni, A. and H. von Storch. 1995. Monte carlo experiments on the effects of serial correlation on the MannKendall test of trends. Meteorologische Zeitschrift N.F, 4(2): 82-85.

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3): 245-259.

Salas, J.D. (1980). Applied modeling of hydrologic times series. Water Resources Publication, 484 pp.

von Storch, V. H. (1995). Misuses of statistical analysis in climate research, In: Analysis of Climate Variability: Applications of Statistical Techniques, ed. von H. V. Storch and A. Navarra A. Springer-Verlag, Berlin: 11-26.

Yue, S. and Wang, C. Y. (2002). Applicability of prewhitening to eliminate the influence of serial correlation on the Mann-Kendall test. Water Resources Research, 38(6), <doi:10.1029/2001WR000861>
}
