% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-temporal_hierarchy.R
\name{temporal_hierarchy}
\alias{temporal_hierarchy}
\title{General Interface for Temporal Hierarchical Forecasting (THIEF) Models}
\usage{
temporal_hierarchy(
  mode = "regression",
  seasonal_period = NULL,
  combination_method = NULL,
  use_model = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{seasonal_period}{A seasonal frequency. Uses "auto" by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}

\item{combination_method}{Combination method of temporal hierarchies, taking one of the following values:
\itemize{
\item "struc" - Structural scaling: weights from temporal hierarchy
\item "mse" - Variance scaling: weights from in-sample MSE
\item "ols" - Unscaled OLS combination weights
\item "bu" - Bottom-up combination – i.e., all aggregate forecasts are ignored.
\item "shr" - GLS using a shrinkage (to block diagonal) estimate of residuals
\item "sam" - GLS using sample covariance matrix of residuals
}}

\item{use_model}{Model used for forecasting each aggregation level:
\itemize{
\item "ets" - exponential smoothing
\item "arima" - arima
\item "theta" - theta
\item "naive" - random walk forecasts
\item "snaive" - seasonal naive forecasts, based on the last year of observed data
}}
}
\description{
\code{temporal_hierarchy()} is a way to generate a \emph{specification} of an Temporal Hierarchical Forecasting model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{thief}. Note this
function requires the \code{thief} package to be installed.
}
\details{
Models can be created using the following \emph{engines}:
\itemize{
\item "thief" (default) - Connects to \code{thief::thief()}
}
}
\section{Engine Details}{


The standardized parameter names in \code{modeltime} can be mapped to their original
names in each engine:\tabular{ll}{
   modeltime \tab thief::thief() \cr
   combination_method \tab comb \cr
   use_model \tab usemodel \cr
}


Other options can be set using \code{set_engine()}.

\strong{thief (default engine)}

The engine uses \code{thief::thief()}.

Function Parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> function (y, m = frequency(y), h = m * 2, comb = c("struc", "mse", "ols", 
#>     "bu", "shr", "sam"), usemodel = c("ets", "arima", "theta", "naive", 
#>     "snaive"), forecastfunction = NULL, aggregatelist = NULL, ...)
}\if{html}{\out{</div>}}

Other options and argument can be set using \code{set_engine()}.

Parameter Notes:
\itemize{
\item \code{xreg} - This model is not set up to use exogenous regressors. Only univariate
models will be fit.
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate:}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
\item XY Interface: \code{fit_xy(x = data[,"date"], y = data$y)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

This model is not set up for use with exogenous regressors.
}

\examples{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(thief)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# ---- HIERARCHICAL ----

# Model Spec - The default parameters are all set
# to "auto" if none are provided
model_spec <- temporal_hierarchy() \%>\%
    set_engine("thief")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit




}
\references{
\itemize{
\item{For forecasting with temporal hierarchies see: Athanasopoulos G., Hyndman R.J., Kourentzes N., Petropoulos F. (2017) Forecasting with Temporal Hierarchies. \emph{European Journal of Operational research}, \bold{262}(\bold{1}), 60-74.}
\item{For combination operators see: Kourentzes N., Barrow B.K., Crone S.F. (2014) Neural network ensemble operators for time series forecasting. \emph{Expert Systems with Applications}, \bold{41}(\bold{9}), 4235-4244.}
}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
