mod <- list()
mod$OLS <- lm(hp ~ drat, data = mtcars)
mod$Logit <- glm(am ~ drat + hp, data = mtcars, family = binomial())

test_that("rounding 5 decimals", {
  raw <- modelsummary(mod, fmt = '%.5f', output="dataframe")
  truth <- c("353.65253", "(76.04873)", "-57.54523", "(20.92205)", "", "")
  expect_equal(truth, unname(raw[[4]])[1:6])
  truth <- c("-29.07608", "(12.41692)", "7.30978", "(3.04660)", "0.01079", "(0.00933)")
  expect_equal(truth, unname(raw[[5]])[1:6])
})

test_that("rounding internal function", {
  fun <- fmt_decimal(3)
  expect_equal(fun(2), "2.000")
})

test_that("fmt integer respects options(OutDec)", {
  options(OutDec=",")
  known <- c("353,6525", "(76,0487)", "-57,5452", "(20,9221)", "", "", "32", "0,201", "0,175", "359,2", "363,6", "-176,588", "7,565", "60,31")
  x <- modelsummary(mod, fmt=4, output="data.frame")
  expect_equal(x$OLS, known)
  options(OutDec=".")
})

test_that("fmt character", {
  options(OutDec = ".")
  known <- c("353.6525", "(76.0487)", "-57.5452", "(20.9221)", "", "", "32", "0.201", "0.175", "359.2", "363.6", "-176.588", "7.565", "60.31")
  x <- modelsummary(mod, fmt="%.4f", output="data.frame")
  expect_equal(x$OLS, known)
})

test_that("fmt function", {
  known <- c("353.6525", "(76.0487)", "-57.5452", "(20.9221)", "", "", "32", "0.201", "0.175", "359.2", "363.6", "-176.588", "7.565", "60.31")
  z <- modelsummary(mod, fmt=function(x) sprintf("%.4f", x), output="data.frame")
  expect_equal(known, z$OLS)
})

test_that("significant digits per term", {
  mod <- lm(mpg ~ hp + drat + qsec, data = mtcars)
  tab <- modelsummary(mod, output = "dataframe", fmt = fmt_significant(2), statistic = "conf.int", gof_map = NA)
  expect_equal(tab[["(1)"]], c("17.7", "[-8.9, 44.4]", "-0.058", "[-0.087, -0.029]", "4.4", "[1.8, 7.1]", "-0.28", "[-1.29, 0.72]"))
})





### FUNCTION FACTORY REFACTOR
mod <- lm(mpg ~ hp + drat + qsec, data = mtcars)

test_that("backward compatibility", {
    tab <- modelsummary(mod, fmt = 3, output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.737")
    tab <- modelsummary(mod, fmt = "%.5f", output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.73662")
    tab <- modelsummary(mod, fmt = function(x) round(x, 2), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.74")
    tab <- modelsummary(mod, fmt = NULL, output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.7366200480466")
})


test_that("function factories", {
    tab <- modelsummary(mod, fmt = fmt_decimal(4), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.7366")
    tab <- modelsummary(mod, fmt = fmt_significant(3), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.7")
    expect_equal(tab[["(1)"]][3], "-0.0580")
    tab <- modelsummary(mod, fmt = fmt_sprintf("%.5f"), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.73662")
    tab <- modelsummary(mod, fmt = fmt_function(function(x) round(x, 2)), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.74")
    tab <- modelsummary(mod, fmt = fmt_statistic(estimate = 4, conf.int = 1), statistic = "conf.int", output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.7366")
    expect_equal(tab[["(1)"]][2], "[-8.9, 44.4]")
    tab <- modelsummary(mod, fmt = fmt_term(hp = 4, drat = 1, default = 2), output = "dataframe")
    expect_equal(tab[["(1)"]][1], "17.74")
    expect_equal(tab[["(1)"]][3], "-0.0580")
})


test_that("complicated", {
    tab <- modelsummary(
        mod,
        output = "data.frame",
        statistic = c("std.error", "statistic", "conf.int"),
        fmt = fmt_statistic(
            estimate = 5,
            std.error = \(x) sprintf("%.3f", x),
            default = fmt_significant(1)),
        gof_map = NA)
    expect_equal(tab[["(1)"]], c("17.73662", "(13.020)", "(1.4)", "[-8.93, 44.41]", "-0.05797", "(0.014)", "(-4.1)", "[-0.09, -0.03]", "4.42875", "(1.292)", "(3.4)", "[1.78, 7.07]", "-0.28407", "(0.489)", "(-0.6)", "[-1.29, 0.72]"))

    tab <- modelsummary(
        mod,
        output = "data.frame",
        fmt = fmt_term(
            "(Intercept)" = 5,
            "hp" = 3,
            default = fmt_sprintf("%.1f")),
        gof_map = NA)
    expect_equal(tab[["(1)"]], c("17.73662", "(13.01979)", "-0.058", "(0.014)", "4.4", "(1.3)", "-0.3", "(0.5)"))
})
