% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typical.R
\name{typical}
\alias{typical}
\title{Find the typical value}
\usage{
typical(x, ...)
}
\arguments{
\item{x}{A vector}

\item{...}{Arguments used by methods}
}
\description{
For numeric, integer, and ordered factor vectors, it returns the median.
For factors, characters, and logical vectors, it returns the most
frequent value. If multiple values are tied for most frequent, it returns
them all. \code{NA} missing values are always silently dropped.
}
\examples{
# median of numeric vector
typical(rpois(100, lambda = 10))

# most frequent value of character or factor
x <- sample(c("a", "b", "c"), 100, prob = c(0.6, 0.2, 0.2), replace = TRUE)
typical(x)
typical(factor(x))

# if tied, returns them all
x <- c("a", "a", "b", "b", "c")
typical(x)

# median of an ordered factor
typical(ordered(c("a", "a", "b", "c", "d")))

}
