% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoaders.R
\name{DataSet.Array}
\alias{DataSet.Array}
\title{R6 class representing an array dataset}
\description{
R6 class representing an array dataset

R6 class representing an array dataset
}
\details{
It loads the data from an R array
}
\examples{

## ------------------------------------------------
## Method `DataSet.Array$length`
## ------------------------------------------------

X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$length() # 20

## ------------------------------------------------
## Method `DataSet.Array$has.next`
## ------------------------------------------------

X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$has.next() # TRUE

## ------------------------------------------------
## Method `DataSet.Array$reset`
## ------------------------------------------------

X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$..get.data..()
ds$..get.data..()
ds$reset()
ds$..get.data..()

## ------------------------------------------------
## Method `DataSet.Array$feed`
## ------------------------------------------------

modello.init()
X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
x = number(rnorm(5))
print(x$v)
ds$feed(x)
print(x$v)
modello.close()
}
\author{
Filippo Monari
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSet.Array$new()}}
\item \href{#method-length}{\code{DataSet.Array$length()}}
\item \href{#method-has.next}{\code{DataSet.Array$has.next()}}
\item \href{#method-reset}{\code{DataSet.Array$reset()}}
\item \href{#method-..pop.index..}{\code{DataSet.Array$..pop.index..()}}
\item \href{#method-..get.data..}{\code{DataSet.Array$..get.data..()}}
\item \href{#method-feed}{\code{DataSet.Array$feed()}}
\item \href{#method-clone}{\code{DataSet.Array$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$new(X, indexes, yi, si)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{array}

\item{\code{indexes}}{subset of indexes along the sliceing dimension}

\item{\code{yi}}{subset of indexes to return as targets}

\item{\code{si}}{index of slicing dimension}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Returns the length of the dataset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$length()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$length() # 20
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has.next"></a>}}
\if{latex}{\out{\hypertarget{method-has.next}{}}}
\subsection{Method \code{has.next()}}{
Returns TRUE if the dataset has still data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$has.next()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$has.next() # TRUE
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the dataset to its initial state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$reset()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
ds$..get.data..()
ds$..get.data..()
ds$reset()
ds$..get.data..()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..pop.index.."></a>}}
\if{latex}{\out{\hypertarget{method-..pop.index..}{}}}
\subsection{Method \code{..pop.index..()}}{
Auxiliary method not to be called directly.
It pops an index from the dataset according to the given method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$..pop.index..(mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{popping mode}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..get.data.."></a>}}
\if{latex}{\out{\hypertarget{method-..get.data..}{}}}
\subsection{Method \code{..get.data..()}}{
Auxiliary method not to be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$..get.data..(mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{popping mode}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-feed"></a>}}
\if{latex}{\out{\hypertarget{method-feed}{}}}
\subsection{Method \code{feed()}}{
Method to feed the bathces of data to 'numbers'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$feed(x, mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{number}

\item{\code{mode}}{popping mode}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{modello.init()
X = matrix(rnorm(100), 20)
ds = DataSet.Array$new(X, 1:20, 1, 1)
x = number(rnorm(5))
print(x$v)
ds$feed(x)
print(x$v)
modello.close()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Array$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
