% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{get_vector_cutpoints}
\alias{get_vector_cutpoints}
\title{Get the cutpoints from a single factor vector.}
\usage{
get_vector_cutpoints(v)
}
\arguments{
\item{v}{vector to get cutpoints from}
}
\value{
a vector containing the unique cutpoints in v
}
\description{
get_vector_cutpoints returns a numeric vector giving the unique
cutpoints of a variable that has been discretized using
vector_bin- more generally, using \code{\link[base]{cut}} and any
functions that depend on \code{\link[base]{cut}}
}
\details{
This function is provided for convienience, and is built to work with the
exact format for discretized variables that is used by the cut family. Hence
it will work for cut, cut_number/cut_interval, and any of the binning
functions from modellingTools, but it is not guaranteed to work for
arbitrary factors with numeric levels
}
\examples{
x <- cut(rnorm(100),c(-1,0,1))
get_vector_cutpoints(x) # -1, 0, 1
}
\seealso{
\code{\link[base]{cut}}, \code{\link[ggplot2]{cut_number}},
\code{\link[ggplot2]{cut_interval}}, \code{\link{vector_bin}}

Other discretization: \code{\link{binned_data_cutpoints}},
  \code{\link{simple_bin}}, \code{\link{vector_bin}}
}

