mod2obspred <- function(model, obs.only = FALSE) {
  # version 1.3 (9 Aug 2024)

  if (methods::is(model, "glm") || methods::is(model, "gam")) {
    obs <- model$y
    if (!obs.only) pred <- model$fitted.values

  } else if (methods::is(model, "gbm")) {
    obs <- model$data$y
    if (!obs.only) {
      pred <- suppressMessages(predict(model, type = "response"))  # checked same as:
      # logit <- function(x) exp(x) / (1 + exp(x))
      # pred <- logit(model$fit)  # but this applies only to binary response
    }

  } else if (methods::is(model, "GBMFit")) {
    obs <- model$gbm_data_obj$y
    if (!obs.only) {
      pred <- suppressMessages(predict(model, type = "response", newdata = model$gbm_data_obj$original_data, n.trees = length(model$trees)))  # checked same as:
      # logit <- function(x) exp(x) / (1 + exp(x))
      # pred <- logit(model$fit)  # but this applies only to binary response
    }

  } else if (methods::is(model, "randomForest")) {
    obs <- as.integer(as.character(model$y))
    if (!obs.only) pred <- predict(model, type = "prob")[ , "1"]

  } else if (methods::is(model, "bart")) {
    if (is.null(model$fit$data)) stop("'$fit$data' section not present in 'model'. Try running 'bart()' with 'keeptrees=TRUE'.")
    obs <- model$fit$data@y  # requires model ran with keeptrees=TRUE
    if (!obs.only) pred <- fitted(model, type = "response")

  } else stop("'model' is of a non-implemented class.")

  if (obs.only) return(data.frame(obs = obs))
  return(data.frame(obs = obs, pred = pred))
}
