pdf("kullbackleibler.pdf", width=7, height=4)
xnv <- seq(-0.75, 0.75, by=0.01)
ynv <- xnv^2
par(mar=c(0,0,3.1,0))
plot(0, -0.5, pch=19, xlim=c(-0.8,0.8), ylim=c(-0.8,0.8), axes=FALSE, xlab="", ylab="", 
     main="Space of distributions (infinite dimensional !)")
text(0, -0.5, pos=4, "true data distribution f")
lines(xnv, ynv)
text(-0.8, 0.64, pos=4, "Normal distributions")
points(-0.5, 0.25, pch=19, col="blue")
text(-0.5, 0.25, expression(paste("N(", mu, ",", sigma^2, ")=f(", theta, ")")), pos=4, col="blue")
xp <- c(0,-0.5)
yp <- c(-0.5,0.25)
lines(xp, yp, col="blue")
text(mean(xp), mean(yp), pos=2, expression(paste(d[KL], "(N(", mu, ",", sigma^2, ")||f)")), col="blue")
points(0,0, pch=19, col="red")
lines(c(0,0), c(-0.5,0), col="red")
text(0, 0, expression(paste("N(", hat(mu)[ML], ",", hat(sigma)[ML]^2, ")=f(", hat(theta)[ML], ")")), pos=3, col="red")
box()
dev.off()