% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_im_lmRob.R
\name{cluster_im_lmRob}
\alias{cluster_im_lmRob}
\title{Cluster-Adjusted Confidence Intervals And p-Values Robust Linear Models}
\usage{
cluster_im_lmRob(
  robmod,
  formula,
  dat,
  cluster,
  ci.level = 0.95,
  drop = TRUE,
  return.vcv = FALSE,
  engine = "robust",
  ...
)
}
\arguments{
\item{robmod}{A robust linear model object created using robust::lmRob() or
robustbase::lmrob().}

\item{formula}{A formula or a string that can be coerced to a formula.}

\item{dat}{A data frame containing the data used in the model.}

\item{cluster}{A formula indicating the clustering
variable in \code{dat}.}

\item{ci.level}{Confidence level for the confidence intervals, default is 0.95.}

\item{drop}{Logical; if TRUE, drops clusters where the model does not converge.}

\item{return.vcv}{Logical; if TRUE, the variance-covariance matrix of the
cluster-averaged coefficients will be returned.}

\item{engine}{Set the engine to "robust" to use robust::lmRob() or "robustbase"
to use robustbase::lmrob(). Default is "robust".}

\item{...}{Additional arguments to be passed to the robust::lmRob() or the
robustbase::lmrob() function.}
}
\value{
A list containing the following elements:
\describe{
\item{p.values}{A matrix of p-values for each independent variable.}
\item{ci}{A matrix with the lower and upper bounds of the confidence intervals
for each independent variable.}
\item{vcv.hat}{The variance-covariance matrix of the cluster-averaged
coefficients, returned if \code{return.vcv} is TRUE.}
\item{beta.bar}{The cluster-averaged coefficients, returned if \code{return.vcv}
is TRUE.}
}
}
\description{
Performs cluster-adjusted inference on a robust linear model object, using
robust linear regression within each cluster. This function is designed to
handle models where observations are clustered, and standard errors need to be
adjusted to account for this clustering. The function applies a robust linear
regression model to each cluster and then aggregates the results.
}
\examples{
form <- Sepal.Length ~ Petal.Length + Petal.Width
mod <- robust::lmRob(formula = form, dat = iris)
cluster_im_lmRob(robmod = mod, formula = form, dat = iris,cluster = ~Species)

}
