% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{opal_files_pull}
\alias{opal_files_pull}
\title{Download files from an Opal environment}
\usage{
opal_files_pull(opal, from, to)
}
\arguments{
\item{opal}{Opal login attributes.}

\item{from}{A character string of a path where the files will be taken from
in R.}

\item{to}{A character string of a path where the files will be placed to in
Opal.}
}
\value{
Folder(s) containing files coming from Opal in user R environment.
}
\description{
Downloads files from an Opal environment to the local environment. This is a
wrapper function for \code{\link[opalr:opal.file_download]{opalr::opal.file_download()}}.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
{

library(opalr)
opal <- 
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')
  
tempdir <- tempdir()
invisible(dir.create(paste0(tempdir,"/a_file")))
invisible(file.create(paste0(tempdir,"/a_file","/file.txt")))
try(opal_files_push(opal, from = paste0(tempdir,"/a_file"), to = tempdir))
try(opal_files_pull(opal, from = paste0(tempdir,"/a_file"), to = tempdir))

}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/en/dev/}{Opal documentation} for
complete documentation.
}
