% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MV_critical}
\alias{MV_critical}
\title{Statistics-adapted values for extended minimum volatility selection.}
\usage{
MV_critical(
  y,
  data,
  R,
  gridm,
  gridtau,
  type = 1L,
  cvalue = 0.1,
  B = 100L,
  lrvmethod = 1L,
  ind = 2L,
  rescale = 0L
)
}
\arguments{
\item{y, }{vector, as used in the Heter_LRV}

\item{data, }{list, a list of data}

\item{R, }{a cube of standard.normal random variables.}

\item{gridm, }{vector, a grid of candidate m's.}

\item{gridtau, }{vector, a grid of candidate tau's.}

\item{type, }{integer, 1 KPSS 2 RS 3 VS 4 KS}

\item{cvalue, }{double, 1-quantile for the calculation of bootstrap variance, default 0.1.}

\item{B, }{integer, number of iterations for the calculation of bootstrap variance}

\item{lrvmethod, }{integer, see also Heter_LRV}

\item{ind, }{integer, the type of kernel,  see also Heter_LRV}

\item{rescale, }{bool, whether to rescale when positiveness of the matrix is not obtained. default 0}
}
\value{
a matrix of critical values
}
\description{
Calculation of the variance of the bootstrap statistics for the extended minimum volatility selection.
}
\examples{
###with Long memory parameter 0.2
param = list(d = -0.2, heter = 2,
 tvd = 0, tw = 0.8, rate = 0.1, cur = 1,
  center = 0.3, ma_rate =  0, cov_tw =  0.2,
  cov_rate = 0.1, cov_center = 0.1,
  all_tw  = 1, cov_trend = 0.7)
n = 1000
data = Qct_reg(n, param)
p = ncol(data$x)
t = (1:n)/n
B_c = 100 ##small value for testing
Rc = array(rnorm(n*p*B_c),dim = c(p,B_c,n))
result1 = LocLinear(0.2, t, data$y, data$x)
critical <- MV_critical(data$y, result1, Rc, c(3,4,5), c(0.2, 0.25, 0.3))
}
\references{
#' Bai, L., and Wu, W. (2023). Detecting long-range dependence for time-varying linear models. To appear in Bernoulli
}
\seealso{
Heter_LRV
}
