% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackAsyncTuning.R
\name{callback_async_tuning}
\alias{callback_async_tuning}
\title{Create Asynchronous Tuning Callback}
\usage{
callback_async_tuning(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_worker_begin = NULL,
  on_eval_after_xs = NULL,
  on_eval_after_resample = NULL,
  on_eval_before_archive = NULL,
  on_worker_end = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.}

\item{on_worker_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization on the worker.
Called in the worker loop.}

\item{on_eval_after_xs}{(\verb{function()})\cr
Stage called after xs is passed.
Called in \code{ObjectiveTuning$eval()}.}

\item{on_eval_after_resample}{(\verb{function()})\cr
Stage called after a hyperparameter configuration is evaluated.
Called in \code{ObjectiveTuning$eval()}.}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveTuning$eval()}.}

\item{on_worker_end}{(\verb{function()})\cr
Stage called at the end of the optimization on the worker.
Called in the worker loop.}

\item{on_result}{(\verb{function()})\cr
Stage called after the result is written.
Called in \code{OptimInstance$assign_result()}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.}
}
\description{
Function to create a \link{CallbackAsyncTuning}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Tuning callbacks can be called from different stages of the tuning process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Tuning
     - on_optimization_begin
    Start Worker
         - on_worker_begin
        Start Evaluation
             - on_eval_after_xs
             - on_eval_after_resample
             - on_eval_before_archive
        End Evaluation
         - on_worker_end
    End Worker
     - on_result
     - on_optimization_end
End Tuning
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A tuning callback works with \link{ContextAsyncTuning}.
}
\details{
When implementing a callback, each function must have two arguments named \code{callback} and \code{context}.
A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Tuning callbacks access \link{ContextAsyncTuning}.
}
